VERSION 5.00
Object = "{19B7F2A2-1610-11D3-BF30-1AF820524153}#1.1#0"; "ccrpftv6.ocx"
Begin VB.Form Form1 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "CCRP FolderTreeview Control Properties demo (VB6)"
   ClientHeight    =   6750
   ClientLeft      =   1770
   ClientTop       =   1830
   ClientWidth     =   9420
   ClipControls    =   0   'False
   LinkTopic       =   "Form1"
   LockControls    =   -1  'True
   MaxButton       =   0   'False
   ScaleHeight     =   450
   ScaleMode       =   3  'Pixel
   ScaleWidth      =   628
   Begin CCRPFolderTV6.FolderTreeview FolderTreeview1 
      Height          =   2940
      Index           =   0
      Left            =   300
      TabIndex        =   35
      Top             =   1500
      Width           =   1995
      _ExtentX        =   3519
      _ExtentY        =   5186
   End
   Begin VB.ComboBox cboCheckBoxes 
      Height          =   315
      Left            =   4800
      Style           =   2  'Dropdown List
      TabIndex        =   9
      Top             =   1140
      Width           =   2715
   End
   Begin VB.TextBox txtSelectionDelay 
      Height          =   285
      Left            =   6960
      MaxLength       =   4
      TabIndex        =   15
      Text            =   "txtSelectionDelay"
      ToolTipText     =   "Delays only the 2nd SelectionChange event, in milliseconds"
      Top             =   825
      Width           =   555
   End
   Begin VB.CheckBox chkVirtualFolders 
      Caption         =   "&Virtual Folders"
      Height          =   225
      Left            =   7680
      TabIndex        =   19
      Top             =   870
      Width           =   1800
   End
   Begin VB.CommandButton cmdExit 
      Caption         =   "E&xit"
      Height          =   375
      Left            =   2640
      TabIndex        =   3
      Top             =   6300
      Width           =   915
   End
   Begin VB.CheckBox chkAutoUpdate 
      Caption         =   "Auto&Update"
      Height          =   225
      Left            =   3720
      TabIndex        =   4
      Top             =   60
      Width           =   1800
   End
   Begin VB.CommandButton cmdAbout 
      Caption         =   "Abo&ut..."
      Height          =   375
      Left            =   2640
      TabIndex        =   2
      Top             =   5820
      Width           =   915
   End
   Begin VB.Frame fraFolderProps 
      Caption         =   "Folder object properties"
      ClipControls    =   0   'False
      Height          =   3645
      Left            =   3720
      TabIndex        =   27
      Top             =   3030
      Width           =   5595
      Begin VB.PictureBox picLargeIcon 
         AutoRedraw      =   -1  'True
         ClipControls    =   0   'False
         Height          =   555
         Left            =   4920
         ScaleHeight     =   33
         ScaleMode       =   3  'Pixel
         ScaleWidth      =   33
         TabIndex        =   33
         TabStop         =   0   'False
         Top             =   2985
         Width           =   555
      End
      Begin VB.PictureBox picSmallIcon 
         AutoRedraw      =   -1  'True
         ClipControls    =   0   'False
         Height          =   315
         Left            =   4380
         ScaleHeight     =   17
         ScaleMode       =   3  'Pixel
         ScaleWidth      =   17
         TabIndex        =   32
         TabStop         =   0   'False
         Top             =   3210
         Width           =   315
      End
      Begin VB.PictureBox picFolderProps 
         Appearance      =   0  'Flat
         BorderStyle     =   0  'None
         ClipControls    =   0   'False
         Enabled         =   0   'False
         ForeColor       =   &H80000008&
         Height          =   2925
         Left            =   150
         ScaleHeight     =   2925
         ScaleWidth      =   5385
         TabIndex        =   31
         TabStop         =   0   'False
         Top             =   600
         Width           =   5385
      End
      Begin VB.OptionButton optFirstVisFolderProps 
         Caption         =   "&FirstVisibleFolder"
         Height          =   225
         Left            =   3600
         TabIndex        =   30
         Top             =   270
         Width           =   1515
      End
      Begin VB.OptionButton optSelFolderProps 
         Caption         =   "Selecte&dFolder"
         Height          =   225
         Left            =   1560
         TabIndex        =   29
         Top             =   270
         Width           =   1395
      End
      Begin VB.OptionButton optFolderPropsOff 
         Caption         =   "&Off"
         Height          =   225
         Left            =   120
         TabIndex        =   28
         Top             =   270
         Value           =   -1  'True
         Width           =   555
      End
   End
   Begin VB.CommandButton cmdPrintTree 
      Caption         =   "&Print Tree to Debug Window"
      Height          =   375
      Left            =   120
      TabIndex        =   1
      Top             =   6300
      Width           =   2355
   End
   Begin VB.CheckBox chkValidateSelection 
      Caption         =   "&ValidateSelection"
      Height          =   225
      Left            =   7680
      TabIndex        =   18
      Top             =   600
      Width           =   1800
   End
   Begin VB.TextBox txtIndent 
      Height          =   285
      Left            =   6405
      MaxLength       =   3
      TabIndex        =   13
      Text            =   "txtIndent"
      ToolTipText     =   "Enter key, LostFocus processes entry"
      Top             =   555
      Width           =   435
   End
   Begin VB.CheckBox chkTooltips 
      Caption         =   "&Tooltips"
      Height          =   225
      Left            =   7680
      TabIndex        =   17
      Top             =   330
      Width           =   1800
   End
   Begin VB.CheckBox chkHideSelection 
      Caption         =   "HideSelectio&n"
      Height          =   225
      Left            =   5700
      TabIndex        =   11
      Top             =   330
      Width           =   1800
   End
   Begin VB.CheckBox chkHasLines 
      Caption         =   "Has&Lines"
      Height          =   225
      Left            =   3720
      TabIndex        =   6
      Top             =   600
      Width           =   1800
   End
   Begin VB.CheckBox chkHasLinesAtRoot 
      Caption         =   "HasLines&AtRoot"
      Height          =   225
      Left            =   3720
      TabIndex        =   7
      Top             =   870
      Width           =   1800
   End
   Begin VB.CheckBox chkHiddenFolders 
      Caption         =   "&HiddenFolders"
      Height          =   225
      Left            =   5700
      TabIndex        =   10
      Top             =   60
      Width           =   1800
   End
   Begin VB.CheckBox chkHasButtons 
      Caption         =   "Has&Buttons"
      Height          =   225
      Left            =   3720
      TabIndex        =   5
      Top             =   330
      Width           =   1800
   End
   Begin VB.CheckBox chkOverlayIcons 
      Caption         =   "Ov&erlayIcons"
      Height          =   225
      Left            =   7680
      TabIndex        =   16
      Top             =   60
      Width           =   1800
   End
   Begin VB.TextBox txtSelFolder 
      Height          =   315
      HelpContextID   =   130
      Left            =   3720
      TabIndex        =   24
      Text            =   "txtSelFolder"
      ToolTipText     =   "Enter key, LostFocus processes entry"
      Top             =   2340
      Width           =   5100
   End
   Begin VB.CommandButton cmdSelFolder 
      Appearance      =   0  'Flat
      Caption         =   "..."
      Height          =   315
      HelpContextID   =   130
      Left            =   8940
      TabIndex        =   25
      Top             =   2340
      Width           =   375
   End
   Begin VB.CommandButton cmdCtrlArray 
      Caption         =   "Load control arra&y (4 total)"
      Height          =   375
      Left            =   120
      TabIndex        =   0
      Top             =   5820
      Width           =   2355
   End
   Begin VB.TextBox txtRootFolder 
      Height          =   315
      HelpContextID   =   120
      Left            =   3720
      TabIndex        =   21
      Text            =   "txtRootFolder"
      ToolTipText     =   "Enter key, LostFocus processes entry"
      Top             =   1740
      Width           =   5100
   End
   Begin VB.CommandButton cmdRootFolder 
      Appearance      =   0  'Flat
      Caption         =   "..."
      Height          =   315
      HelpContextID   =   120
      Left            =   8940
      TabIndex        =   22
      Top             =   1740
      Width           =   375
   End
   Begin VB.Label Label1 
      Caption         =   "&CheckBoxes:"
      Height          =   225
      Left            =   3720
      TabIndex        =   8
      Top             =   1200
      Width           =   1035
   End
   Begin VB.Label balSelectionDelay 
      Caption         =   "&SelectionDelay:"
      Height          =   225
      Left            =   5700
      TabIndex        =   14
      Top             =   870
      Width           =   1260
   End
   Begin VB.Label labNewFTVInfo 
      Caption         =   "If adding a new FolderTreeview control, set the following properties in designtime: Index = 0."
      Height          =   885
      Left            =   60
      TabIndex        =   34
      Top             =   270
      UseMnemonic     =   0   'False
      Width           =   2475
   End
   Begin VB.Shape shpFTVSize 
      Height          =   4830
      Left            =   0
      Top             =   0
      Width           =   2655
   End
   Begin VB.Label labGetVisCount 
      Caption         =   "GetVisibleCount:"
      Height          =   225
      Left            =   3720
      TabIndex        =   26
      Top             =   2730
      Width           =   3840
   End
   Begin VB.Label labIndent 
      Caption         =   "&Indent:"
      Height          =   225
      Left            =   5700
      TabIndex        =   12
      Top             =   600
      Width           =   615
   End
   Begin VB.Label labSelFolder 
      Caption         =   "&SelectedFolder:"
      Height          =   225
      Left            =   3720
      TabIndex        =   23
      Top             =   2100
      Width           =   1500
   End
   Begin VB.Label labRootFolder 
      Caption         =   "&RootFolder:"
      Height          =   225
      Left            =   3720
      TabIndex        =   20
      Top             =   1500
      Width           =   1500
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

' Brought to you by Brad Martinez
'   http://www.mvps.org/ccrp/
'   news://news.mvps.org/ccrp.foldertreeview

' =========================================================
' Demonstrates the behavior and effect of most of the Properties in the
' FolderTreeview control.
'
' - Code was developed using (and is formatted for) 8pt. MS Sans Serif font
' =========================================================

' Flag used to set the top FTV's SelectionDelay property to 0
' when a folder is selected with the left mouse button, allowing
' SelectionDelay to affect only FTV keyboard navigation.
Private m_fMouseSelection As Boolean

' Flag set and cleared in both cmdCtrlArray_Click, preventing
' FolderTreeview1_SelectionChange code execution, and in
' UpdateFTVProps(), preventing VB control click code execution
' as a result of the checkbox values changing.
Private m_fLoading As Boolean

' Event object variable allowing reference to frmBrowseDlg and
' receipt of it's one and only raised event, SelectionChanged.
Private WithEvents BrowseDlg As frmBrowseDlg
Attribute BrowseDlg.VB_VarHelpID = -1

' Variable that holds the number of space chars that roughly matches
' the pixel width of the FolderTreeview's current Indent property setting.
' For printing the FolderTreeview's tree. See the PrintFolderTree proc.
Dim m_wIndentSpcs As Integer
'

Private Sub Form_Load()

  Set BrowseDlg = frmBrowseDlg
  
  Move (Screen.Width - Width) * 0.5, (Screen.Height - Height) * 0.5

  ' Use the Shape control's coords to position the FTV
  FolderTreeview1(0).Move 0, 0, shpFTVSize.Width, shpFTVSize.Height

  ' Generates a FolderTreeview1_GotFocus() when form is shown.
  FolderTreeview1(0).TabIndex = 0

  ' Can't position controls in the control array in
  ' cmdCtrlArray_Click() if the FolderTreeview's Align
  ' prop is set to anything other than vbAlignNone.
  If (FolderTreeview1(0).Align <> vbAlignNone) Then
    cmdCtrlArray.Enabled = False
    cmdCtrlArray.Caption = "Align must be set to vbAlignNone"
  End If

  ' Load the checkboxes combo, constant values correspond to ListIndex
  With cboCheckBoxes
    .AddItem "NoCheckboxes = 0"   ' clear all folder check states
    .AddItem "ClickSelect = 1"
    .AddItem "ClickNoSelect = 2"
    .AddItem "NoCheckboxesPreserveState = 3"  ' preserve all folder check states
  End With
  
  ' Disable the "Print Tree..." command button if executing
  ' from the demo's compiled executable.
  cmdPrintTree.Enabled = InIDE

End Sub

' Slick little trick from the Feb 98 VBPJ Tect Tips...

Private Function InIDE() As Boolean
  On Error GoTo Out

  ' This line errs only in the IDE.
  ' The Debug object is not evaluated in compiled executables...
  Debug.Print 1 / 0

Out:
  InIDE = CBool(Err)

End Function

' On first click, loads the FolderTreeview control array, initializing
' each control's properties. On subsequent clicks, toggles the
' visibility of all but the first control in the array.

Private Sub cmdCtrlArray_Click()
  Dim wLeft As Integer
  Dim wTop As Integer
  Dim i As Integer
  Static fLoaded As Boolean
  Static fHidden As Boolean
  Static iTopFTV As Integer

  If Not fLoaded Then
    fLoaded = True
    m_fLoading = True
    cmdCtrlArray.Caption = "Hide &control array"
    wLeft = FolderTreeview1(0).Left
    wTop = FolderTreeview1(0).Top
    For i = 1 To 3
      Load FolderTreeview1(i)
      With FolderTreeview1(i)
        .Left = wLeft + (i * 15)
        .Top = wTop + (i * 15)
        .TabIndex = i
        .Tag = ""
        .Visible = True
      End With
    Next
    m_fLoading = False

  ElseIf Not fHidden Then
    fHidden = True
    cmdCtrlArray.Caption = "Show &control array"
    For i = 1 To 3:  FolderTreeview1(i).Visible = False: Next
    ' save the current top ftv's index and clear it's tag
    iTopFTV = TopFTV.Index
    FolderTreeview1(iTopFTV).Tag = ""
    FolderTreeview1(0).Tag = "topftv"
    Call UpdateFTVProps(0)
    Call UpdateFolderProps(0)

  Else
    fHidden = False
    cmdCtrlArray.Caption = "Hide &control array"
    For i = 1 To 3:  FolderTreeview1(i).Visible = True: Next
    FolderTreeview1(0).Tag = ""
    ' set the prev top ftv from the index we saved above, and set it's tag
    FolderTreeview1(iTopFTV).Tag = "topftv"
    Call UpdateFTVProps(iTopFTV)
    Call UpdateFolderProps(iTopFTV)
  End If

End Sub

' Returns the topmost FolderTreeview object (whose Tag is "topftv").

Private Function TopFTV() As FolderTreeview
  Dim ctrl As Control

  For Each ctrl In Controls
    If TypeOf ctrl Is FolderTreeview Then
      If ctrl.Tag = "topftv" Then
        Set TopFTV = ctrl: Exit Function
      End If
    End If
  Next

  ' The tag wasn't found above, go with the first FolderTreeview.
  ' FolderTreeview1_GotFocus will set it's tag...
  Set TopFTV = FolderTreeview1(0)

End Function

' Displays the FolderTreeview's SelectedFolder, and updates the demo's
' FolderTreeview and Folder object property controls reflecting their current value.

Private Sub UpdateAll(Index As Integer)
  FolderTreeview1(Index).SelectedFolder.Selected = True
  Call UpdateFTVProps(Index)
  Call UpdateFolderProps(Index)
End Sub

' Updates the demo's FolderTreeview property controls reflecting the currently
' selected FolderTreeview control's properties.

Private Sub UpdateFTVProps(Index As Integer)

  ' Set the mod level flag so we don't fire the VB controls' Click
  ' events when reflecting the FTV's properties in them below.
  m_fLoading = True

  With FolderTreeview1(Index)
    chkAutoUpdate = Abs(.AutoUpdate)
    cboCheckBoxes.ListIndex = .CheckBoxes
    chkHasButtons = Abs(.HasButtons)
    chkHasLines = Abs(.HasLines)
    chkHasLinesAtRoot = Abs(.HasLinesAtRoot)
    chkHiddenFolders = Abs(.HiddenFolders)
    chkHideSelection = Abs(.HideSelection)
    chkOverlayIcons = Abs(.OverlayIcons)
    chkTooltips = Abs(.Tooltips)
    chkValidateSelection = Abs(.ValidateSelection)
    chkVirtualFolders = Abs(.VirtualFolders)
    txtIndent = .Indent
    txtSelectionDelay = .SelectionDelay

    labGetVisCount = "GetVisibleCount:  " & .GetVisibleCount
  End With

  m_fLoading = False

End Sub

' Updates the demo's Folder object property controls reflecting the currently
' selected Folder object's properties.

Private Sub UpdateFolderProps(Index As Integer)
  Dim fldCur As CCRPFolderTV6.Folder
  Dim sText As String
  On Error Resume Next   ' fldCur's Folder object references may be Nothing

  txtRootFolder = FolderTreeview1(Index).RootFolder.Name
  txtSelFolder = FolderTreeview1(Index).SelectedFolder.Name

  If optFolderPropsOff Then Exit Sub
  
  ' Get a reference to either the SelectedFolder or FirstVisibleFolder
  If optSelFolderProps Then
    Set fldCur = FolderTreeview1(Index).SelectedFolder
  Else
    Set fldCur = FolderTreeview1(Index).FirstVisibleFolder
  End If

  With fldCur
    sText = sText & "(Name):" & vbTab & vbTab & .Name & vbCrLf
    sText = sText & "Checked:" & vbTab & .Checked & vbCrLf
    sText = sText & "Child:" & vbTab & vbTab & .Child & vbCrLf   ' will err if Nothing
    sText = sText & "Children:" & vbTab & .Children & vbCrLf
    sText = sText & "DisplayName:" & vbTab & .DisplayName & vbCrLf
    sText = sText & "Expanded:" & vbTab & .Expanded & vbCrLf
    sText = sText & "FirstSibling:" & vbTab & .FirstSibling & vbCrLf   ' can't be Nothing
    sText = sText & "FullPath:" & vbTab & .FullPath & vbCrLf
    sText = sText & "IsValid:" & vbTab & vbTab & .IsValid & vbCrLf
    sText = sText & "LastSibling:" & vbTab & .LastSibling & vbCrLf   ' can't be Nothing
    sText = sText & "NextSibling:" & vbTab & .NextSibling & vbCrLf   ' will err if Nothing
    sText = sText & "Parent:" & vbTab & vbTab & .Parent & vbCrLf   ' will err if Nothing
    sText = sText & "PrevSibling:" & vbTab & .PrevSibling & vbCrLf   ' can't be Nothing
    sText = sText & "Selected:" & vbTab & .Selected & vbCrLf
    sText = sText & "Siblings:" & vbTab & vbTab & .Siblings & vbCrLf & vbCrLf
    picSmallIcon = .SmallIcon    ' (ftvSelected Or ftvShareOverlay)
    picLargeIcon = .LargeIcon   ' (ftvOpenIcon Or ftvSelected Or ftvShortcutOverlay)
  End With

  With picFolderProps
    .AutoRedraw = True
    .Cls
    picFolderProps.Print sText
    .AutoRedraw = False
  End With

End Sub

' ==================================================================
' FolderTreeview events:

' Clears the Tag of the prev top FolderTreeview, sets the Tag of
' the new top FolderTreeview to "topftv", and brings it to the top.

Private Sub FolderTreeview1_GotFocus(Index As Integer)
  TopFTV.Tag = ""
  FolderTreeview1(Index).Tag = "topftv"
  FolderTreeview1(Index).ZOrder 0
  Call UpdateFTVProps(Index)
  Call UpdateFolderProps(Index)
End Sub

Private Sub FolderTreeview1_KeyDown(Index As Integer, KeyCode As Integer, Shift As Integer)
  
  ' Clear the module level flag so that SelectionDelay is used in
  ' FolderTreeview1_SelectionChange for keyboard navigation.
  m_fMouseSelection = False
  
  ' On an F5 keypress, refresh the top FolderTreeview's folder contents
  ' and update the properties of the currently (or newly) selected folder
  ' (in case a folder was added/moved/renamed/deleted...)
  If KeyCode = vbKeyF5 Then
    FolderTreeview1(Index).Refresh
    Call UpdateFTVProps(Index)
    Call UpdateFolderProps(Index)
  End If

End Sub

' Set the module level flag so that SelectionDelay is not used
' in FolderTreeview1_SelectionChange for mouse navigation.

Private Sub FolderTreeview1_MouseDown(Index As Integer, Button As Integer, Shift As Integer, x As Single, y As Single)
  m_fMouseSelection = True
End Sub

' The SelectionDelay property returns/sets the time in milliseconds that
' the *second* SelectionChange event (PreChange = False) is delayed.

Private Sub FolderTreeview1_SelectionChange(Index As Integer, Folder As CCRPFolderTV6.Folder, PreChange As Boolean, Cancel As Boolean)
  
  If PreChange Then
    ' If the selection change occured from the mouse, turn SelectionDelay
    ' off before the PreChange = False event occurs next.
    If m_fMouseSelection Then
      FolderTreeview1(Index).SelectionDelay = 0
    End If
  
  Else
    ' If the selection change occured from the mouse, restore the currently
    ' specified value. If the selection change occured from the keyboard,
    ' then this event has been delayed by the specified SelectionDelay value.
    If m_fMouseSelection Then
      FolderTreeview1(Index).SelectionDelay = Val(txtSelectionDelay)
    End If
    
    ' Display the folder properties for the selected folder
    Call UpdateFolderProps(Index)
    
  End If

End Sub

' Update the properties of the collapsed folder.

Private Sub FolderTreeview1_Collapse(Index As Integer, Folder As CCRPFolderTV6.Folder, PreCollapse As Boolean, Cancel As Boolean)
  If (PreCollapse = False) Then
    Call UpdateFolderProps(Index)
  End If
End Sub

' Update the properties of the expanded folder.

Private Sub FolderTreeview1_Expand(Index As Integer, Folder As CCRPFolderTV6.Folder, PreExpand As Boolean, Cancel As Boolean)
  If (PreExpand = False) Then
    Call UpdateFolderProps(Index)
  End If
End Sub

' Update the properties of the clicked (selected) folder for checkbox clicks.

Private Sub FolderTreeview1_FolderClick(Index As Integer, Folder As CCRPFolderTV6.Folder, Location As CCRPFolderTV6.ftvHitTestConstants)
  If m_fMouseSelection And (Location And ftvOnFolderCheckBox) Then
    Call UpdateFolderProps(Index)
  End If
End Sub

' Update the FTVs' Folder properties when changes happen in the shell

Private Sub FolderTreeview1_FolderUpdate(Index As Integer, FolderName As String, EventID As CCRPFolderTV6.ftvFolderUpdateConstants)
  Call UpdateFolderProps(Index)
End Sub

' Update the visible folder count property
' reflecting any vertical scrollbar change.

Private Sub FolderTreeview1_VScroll(Index As Integer)
  labGetVisCount = "GetVisibleCount:  " & TopFTV.GetVisibleCount
  If optFirstVisFolderProps Then Call UpdateFolderProps(Index)
End Sub

' ==================================================================
' FolderTreeview's RootFolder property:

' Processes textbox entry on Enter key

Private Sub txtRootFolder_KeyPress(KeyAscii As Integer)
  If KeyAscii = vbKeyReturn Then
    If TopFTV.RootFolder <> txtRootFolder Then
      KeyAscii = 0   ' lose the beep
      TopFTV.RootFolder = txtRootFolder
      Call UpdateAll(TopFTV.Index)
    End If
  End If
End Sub

' Processes textbox entry on LostFocus

Private Sub txtRootFolder_LostFocus()
  If TopFTV.RootFolder <> txtRootFolder Then
    TopFTV.RootFolder = txtRootFolder
    Call UpdateAll(TopFTV.Index)
  End If
End Sub

' Retrieves and sets the FolderTreeview's RootFolder property.

Private Sub cmdRootFolder_Click()
  Dim sFolder As String
  sFolder = BrowseForFolder("Specify the FolderTreeview's RootFolder", TopFTV.RootFolder)
  If Len(sFolder) And (TopFTV.RootFolder <> sFolder) Then
    TopFTV.RootFolder = sFolder
    Call UpdateAll(TopFTV.Index)
  End If
End Sub

' ==================================================================
' FolderTreeview's SelectedFolder property:

' Processes textbox entry on Enter key

Private Sub txtSelFolder_KeyPress(KeyAscii As Integer)
  If KeyAscii = vbKeyReturn Then
    If TopFTV.SelectedFolder <> txtSelFolder Then
      KeyAscii = 0   ' lose the beep
      TopFTV.SelectedFolder = txtSelFolder
      Call UpdateAll(TopFTV.Index)
    End If
  End If
End Sub

' Processes textbox entry on LostFocus

Private Sub txtSelFolder_LostFocus()
  If TopFTV.SelectedFolder <> txtSelFolder Then
    TopFTV.SelectedFolder = txtSelFolder
    Call UpdateAll(TopFTV.Index)
  End If
End Sub

' Retrieves and sets the FolderTreeview's SelectedFolder property.

Private Sub cmdSelFolder_Click()
  Dim sFolder As String
  sFolder = BrowseForFolder("Specify the FolderTreeview's SelectedFolder", TopFTV.SelectedFolder)
  If Len(sFolder) And (TopFTV.SelectedFolder <> sFolder) Then
    TopFTV.SelectedFolder = sFolder
    Call UpdateAll(TopFTV.Index)
  End If
End Sub

' ==================================================================
' Browse dialog (frmBrowseDlg):

' Initializes & shows frmBrowseDlg, returns the folder's string selected in the dialog.

Private Function BrowseForFolder(sPrompt As String, sSelFolder As String) As String
  With BrowseDlg
    ' Initialize the browse dialog.
    .Owner = Me
    .Prompt1 = sPrompt
    .RootFolder = .FolderString(ftvDesktop)
    .PreSelectedFolder = sSelFolder
    .ShowPrompt2 = True 'False ' True
    ' Show's the browse dialog, returns a Boolean
    If .Browse Then
      BrowseForFolder = .SelectedFolder.Name
    End If
  End With
End Function

' Displays the current frmBrowseDlg folder selection if showing the second prompt.

Private Sub BrowseDlg_SelectionChanged(Folder As CCRPFolderTV6.Folder)
  If BrowseDlg.ShowPrompt2 Then BrowseDlg.Prompt2 = Folder.Name
End Sub

Private Sub cmdAbout_Click()
  Call FolderTreeview1(0).AboutBox
End Sub

Private Sub cmdExit_Click()
  Unload Me
End Sub

' ==================================================================
' FolderTreeview property controls:

Private Sub chkAutoUpdate_Click()
  If Not m_fLoading Then TopFTV.AutoUpdate = chkAutoUpdate
End Sub

Private Sub cboCheckBoxes_Click()
  If Not m_fLoading Then TopFTV.CheckBoxes = cboCheckBoxes.ListIndex
End Sub

Private Sub chkHasButtons_Click()
  If Not m_fLoading Then TopFTV.HasButtons = chkHasButtons
End Sub

Private Sub chkHasLines_Click()
  If Not m_fLoading Then TopFTV.HasLines = chkHasLines
End Sub

Private Sub chkHasLinesAtRoot_Click()
  If Not m_fLoading Then TopFTV.HasLinesAtRoot = chkHasLinesAtRoot
End Sub

Private Sub chkHiddenFolders_Click()
  If Not m_fLoading Then TopFTV.HiddenFolders = chkHiddenFolders
End Sub

Private Sub chkHideSelection_Click()
  If Not m_fLoading Then TopFTV.HideSelection = chkHideSelection
End Sub

Private Sub chkOverlayIcons_Click()
  If Not m_fLoading Then TopFTV.OverlayIcons = chkOverlayIcons
End Sub

Private Sub chkTooltips_Click()
  If Not m_fLoading Then TopFTV.Tooltips = chkTooltips
End Sub

Private Sub chkValidateSelection_Click()
  If Not m_fLoading Then TopFTV.ValidateSelection = chkValidateSelection
End Sub

Private Sub chkVirtualFolders_Click()
  If Not m_fLoading Then TopFTV.VirtualFolders = chkVirtualFolders
End Sub

Private Sub txtIndent_KeyPress(KeyAscii As Integer)
  If KeyAscii = vbKeyReturn Then
    KeyAscii = 0   ' lose the beep
    TopFTV.Indent = Val(txtIndent)
    txtIndent = TopFTV.Indent   ' reflect actual set value
  End If
End Sub

Private Sub txtSelectionDelay_LostFocus()
  TopFTV.SelectionDelay = txtSelectionDelay
  txtSelectionDelay = TopFTV.SelectionDelay   ' reflect actual set value
End Sub

Private Sub txtSelectionDelay_KeyPress(KeyAscii As Integer)
  If KeyAscii = vbKeyReturn Then
    KeyAscii = 0   ' lose the beep
    TopFTV.SelectionDelay = Val(txtSelectionDelay)
    txtSelectionDelay = TopFTV.SelectionDelay   ' reflect actual set value
  End If
End Sub

Private Sub txtIndent_LostFocus()
  TopFTV.Indent = txtIndent
  txtIndent = TopFTV.Indent   ' reflect actual set value
End Sub

Private Sub optFolderPropsOff_Click()
  Set picFolderProps = Nothing
  Set picSmallIcon = Nothing
  Set picLargeIcon = Nothing
End Sub

Private Sub optSelFolderProps_Click()
  Call UpdateFolderProps(TopFTV.Index)
End Sub

Private Sub optFirstVisFolderProps_Click()
  Call UpdateFolderProps(TopFTV.Index)
End Sub

' ==================================================================
' Example of how to obtain and print the FolderTreeview's tree.

Private Sub cmdPrintTree_Click()
  Call PrintFolderTree(TopFTV.RootFolder, Me, True)
End Sub

' Prints the specified contents of the FolderTreeview to the specified target object.

'   objRootFolder   ' FolderTreeview Folder object which will be the root of the print output
'   objPrintTarget   ' target object reference, either the Printer object, or a Form object
'                              (in which case the contents will be printed to the Immediate window)
'   fPrintAllItems     ' flag specifying whether to print all loaded folders or just visible folders

Private Sub PrintFolderTree(objRootFolder As Folder, _
                                            objPrintTarget As Object, _
                                            fPrintAllItems As Boolean)
  Dim OldSM As ScaleModeConstants
  Dim sIndent As String
  Dim wIndent As Integer
  Const vbSpace = " "
  Dim sFolders As String

  ' Save the print target's current scalemode
  OldSM = objPrintTarget.ScaleMode

  ' Set the print target's scalemode to pixels
  objPrintTarget.ScaleMode = vbPixels

  ' Get the FolderTreeview's Indent pixel value.
  wIndent = TopFTV.Indent

  ' Establish a rough indent distance
  Do While objPrintTarget.TextWidth(sIndent) < wIndent
    sIndent = sIndent & vbSpace
  Loop

  ' Set the module level variable containing the number
  ' of spaces that roughly equals the FolderTreeview's indent.
  m_wIndentSpcs = Len(sIndent)

  ' Retsore the print target's scalemode to it's previous setting
  objPrintTarget.ScaleMode = OldSM

  ' Fill up the string with all of the FolderTreeview's items
  Call FillFolderTreeStr(objRootFolder, fPrintAllItems, _
                                   Abs(TopFTV.HasLinesAtRoot), sFolders)

  ' And finally, print the string to the specified target object
  If (TypeOf objPrintTarget Is Printer) Then
    Printer.Print sFolders
    Printer.EndDoc
  Else
    Debug.Print sFolders
  End If

End Sub

' Prepends to the passed string both the displayname of the specified parent
' FolderTreeview folder and the displaynames all of the parent folder's children folders.

'   objParentFolder   ' parent Folder object
'   fGetAllFolders      ' flag specifying whether to fill the string with all folders,
'                                or just visible folders
'   wIndentLevel      ' level of indent, the root item is 1, it's chidren are 2, their
'                                children are 3, etc.
'   sFolders              ' passed string that is being filled

Private Sub FillFolderTreeStr(objParentFolder As Folder, _
                                             fGetAllFolders As Boolean, _
                                             wIndentLevel As Integer, _
                                             sFolders As String)
  Dim objChildFolder As Folder

  ' First prepend the current parent folder's displayname to the passed string.
  sFolders = sFolders & _
                    String$(m_wIndentSpcs * wIndentLevel, vbKeySpace) & _
                    objParentFolder.DisplayName & vbCrLf

  ' If we're just retrieving visible folders and the current
  ' parent folder is not expanded, then exit the proc.
  If fGetAllFolders = False Then
    If objParentFolder.Expanded = False Then Exit Sub
  End If

  ' Get the handle of the current parent folder's first child.
  Set objChildFolder = objParentFolder.Child

  ' Increment the indent level.
  wIndentLevel = wIndentLevel + 1

  ' Now walk through the current parent folder's children prepending
  ' the current child folder's displayname to the passed string.
  Do While Not (objChildFolder Is Nothing)

    ' If the current child folder has it's own children...
    If objChildFolder.Children Then
      ' Recursively call this proc, filling the passed string
      ' with the current child folder and it's children folders.
      Call FillFolderTreeStr(objChildFolder, fGetAllFolders, wIndentLevel, sFolders)

    Else
      ' Prepend the current child folder's displayname to the passed string.
      sFolders = sFolders & _
                        String$(m_wIndentSpcs * wIndentLevel, vbKeySpace) & _
                        objChildFolder.DisplayName & vbCrLf
    End If

    ' Get the current child folder's next sibling
    Set objChildFolder = objChildFolder.NextSibling

  Loop

  ' Decrement the indent level.
  wIndentLevel = wIndentLevel - 1

End Sub
